IF EXISTS (SELECT* FROM SYS.VIEWS WHERE NAME = 'V_TELE_ORC_TRANSPORTE_TRANSACAO' )
BEGIN 
	DROP VIEW V_TELE_ORC_TRANSPORTE_TRANSACAO
END 
GO 

CREATE VIEW V_TELE_ORC_TRANSPORTE_TRANSACAO

WITH ENCRYPTION
AS
		SELECT  TELE_ORC.CD_FILIAL, 
			TELE_ORC.CD_CLI,
			TELE_ORC.CD_ORC,
			TELE_ORC.DTHR_PEDIDO,
			TELE_ORC.CD_USU,
			CASE WHEN TELE_ORC_TRANSPORTE_TRANSACAO.SUCCESS = 1 THEN 'ENVIADO COM SUCESSO'
			     ELSE 'FALHA NO ENVIO'
			 END AS STATUS_TRANSPORTADORA,
			TELE_ETAPA_VALIDACAO.DS_ETAPA_VALIDACAO		AS STATUS_ATUAL_PEDIDO,
			--CASE 
			--	 WHEN TELE_ORC.CD_ETAPAS = 1					 THEN 'RECEBIMENTO'
			--	 WHEN TELE_ORC.CD_ETAPAS = 2					 THEN 'CONFECAO'
			--	 WHEN TELE_ORC.CD_ETAPAS = 3					 THEN 'SEPARACAO'
			--	 WHEN TELE_ORC.CD_ETAPAS = 4 AND TELE_ORC.CD_TIPO =  0 THEN 'COM A TRANSPORTADORA' 
			--	 WHEN TELE_ORC.CD_ETAPAS = 5 AND TELE_ORC.CD_TIPO =  0 THEN 'ENTREGUE'
			--	 WHEN TELE_ORC.CD_ETAPAS = 6					 THEN 'CANCELADO'
			--	 WHEN TELE_ORC.CD_ETAPAS = 7					 THEN 'ALTERACAO'
			--	 WHEN TELE_ORC.CD_ETAPAS = 8					 THEN 'PENDENCIA'
			--	 WHEN TELE_ORC.CD_ETAPAS = 9					 THEN 'RETORNO'
			--	 WHEN TELE_ORC.CD_ETAPAS = 10					 THEN 'DEVOLUCAO TOTAL'
			--	 WHEN TELE_ORC.CD_ETAPAS = 11					 THEN 'EMITINDO CUPOM FISCAL'
			--	 WHEN TELE_ORC.CD_ETAPAS = 12					 THEN 'PESQUISA'
			--	 WHEN TELE_ORC.CD_ETAPAS = 13					 THEN 'CANCELADO CUPOM'
			--	 WHEN TELE_ORC.CD_ETAPAS = 14					 THEN 'DEVOLUCAO PARCIAL'
			-- END  AS STATUS_ATUAL_PEDIDO,
			CASE WHEN TELE_ORC_ETAPA.MAIS_ENTREGAS = 0 THEN 'NENHUMA' 
				 WHEN TELE_ORC_ETAPA.MAIS_ENTREGAS = 1 THEN 'CORREIOS'
				 WHEN TELE_ORC_ETAPA.MAIS_ENTREGAS = 2 THEN 'JADLOG' 
				 WHEN TELE_ORC_ETAPA.MAIS_ENTREGAS = 3 THEN 'MAIS ENTREGAS' 
			 END     AS TRANSPORTADORA 
	  FROM TELE_ORC
		   JOIN TELE_ORC_TRANSPORTE_TRANSACAO ON TELE_ORC_TRANSPORTE_TRANSACAO.CD_ORC = TELE_ORC.CD_ORC
		   JOIN TELE_ETAPA_VALIDACAO ON TELE_ORC.CD_ETAPAS = TELE_ETAPA_VALIDACAO.CD_ETAPA
								    AND TELE_ORC.CD_TIPO = TELE_ETAPA_VALIDACAO.CD_TIPO
		   JOIN 
			   ( SELECT TELE_ORC_ETAPA.CD_ORC,
						TELE_EMPRESA_ENTREGA.MAIS_ENTREGAS
					FROM TELE_ORC_ETAPA
						 JOIN TELE_ORC_ETAPA_SAIDA ON TELE_ORC_ETAPA_SAIDA.CD_ORC_ETAPA = TELE_ORC_ETAPA.CD_ORC_ETAPA
						 JOIN TELE_SAIDA ON TELE_SAIDA.CD_SAIDA  = TELE_ORC_ETAPA_SAIDA.CD_SAIDA
						 JOIN TELE_ENTREGADOR ON TELE_ENTREGADOR.CD_ENTREGADOR  = TELE_SAIDA.CD_ENTREGADOR
						 JOIN TELE_EMPRESA_ENTREGA ON TELE_EMPRESA_ENTREGA.CD_EMP_ENTREGA  = TELE_ENTREGADOR.CD_EMP_ENTREGA
			   ) TELE_ORC_ETAPA ON  TELE_ORC_ETAPA.CD_ORC  = TELE_ORC.CD_ORC

		  
							  


		 
	    